import { Component, ElementRef } from '@angular/core';
import { NavController, App } from 'ionic-angular';

import { ShopDetailPage } from "../shop-detail/shop-detail";
import { ShopListPage } from "../shop-list/shop-list";
import { ProductListPage } from "../product-list/product-list";
import { ProductDetailPage } from "../product-detail/product-detail";

import { HeaderContentProvider } from "../../providers/header-content/header-content";
import { HomeServiceProvider } from "../../providers/home-service/home-service";
import { HomeModel } from "../../models/pages/home.model";
import { LoadingProvider } from '../../providers/loading/loading';
import { CategoryPage } from '../category/category';

@Component({
  selector: 'page-home',
  templateUrl: 'home.html'
})
export class HomePage {
  // header scroll
  ionScroll: any;
  start: number = 0;
  slideHeaderPrevious: number = 0;
  hideheader: boolean;
  showheader: boolean;
  // End header scroll
  homeData: HomeModel = new HomeModel();
  home: string = 'promotions';
  showPromotions: boolean = false;
  showShops: boolean = false;
  showProducts: boolean = false;

  constructor(public navCtrl: NavController, public app: App, public myElement: ElementRef, public headerContentProvider: HeaderContentProvider, public homeServiceProvider: HomeServiceProvider, public loadingProvider: LoadingProvider) {
    setTimeout(() => {
      this.showPromotions = true;
    }, 1000);
  }

  ionViewDidLoad() {
    console.log('HomePage');
    this.onHeaderScroll();
    this.getHomeData();
  }

  onHeaderScroll() {
    this.hideheader = false;
    this.showheader = true;
    this.ionScroll = this.myElement.nativeElement.getElementsByClassName('scroll-content')[0];
    this.ionScroll.addEventListener("scroll", () => {
      this.hideheader = this.headerContentProvider.getContent(this.ionScroll.scrollTop);
      this.showheader = !this.hideheader;
      if (this.slideHeaderPrevious >= this.ionScroll.scrollTop - this.start) {
        this.hideheader = false;
        this.showheader = true;
      }
      this.slideHeaderPrevious = this.ionScroll.scrollTop - this.start;
    });
  }

  getHomeData() {
    this.loadingProvider.onLoading();
    this.homeServiceProvider.getHomeData().then((data) => {
      this.homeData = data;
      console.log(this.homeData);
      setTimeout(() => {
        this.loadingProvider.dismiss();
      }, 1000);
    }, (error) => {
      // console.log(JSON.parse(error._body).message);
      console.log(error);
      this.loadingProvider.dismiss();
      setTimeout(() => {
      }, 1000);
    });
  }

  setHideItems(home) { //set delay on show item

    this.showPromotions = false;
    this.showShops = false;
    this.showProducts = false;
    this.loadingProvider.onLoading();

    setTimeout(() => {
      if (home === 'promotions') {
        this.showPromotions = true;
      } else if (home === 'shops') {
        this.showShops = true;
      } else if (home === 'products') {
        this.showProducts = true;
      }
      this.loadingProvider.dismiss();

    }, 500);
  }

  goToCategory() {
    this.app.getRootNav().push(CategoryPage);
  }

  goToBestsellerMore() {
    this.app.getRootNav().push(ProductListPage);
  }

  goToNewProductMore() {
    this.app.getRootNav().push(ProductListPage);
  }

  goToShopDetail() {
    this.app.getRootNav().push(ShopDetailPage);
  }

  goToProductList() {
    this.app.getRootNav().push(ShopListPage);
  }

  goToDetail() {
    this.app.getRootNav().push(ProductDetailPage);
  }

}
