import { Component } from '@angular/core';
import { App, NavController, NavParams } from 'ionic-angular';
import { ProductDetailServiceProvider } from "../../providers/product-detail-service/product-detail-service";
import { ProductDetailModel } from "../../models/pages/product-detail.model";
import { LoadingProvider } from '../../providers/loading/loading';

/**
 * Generated class for the ProductDetailPage page.
 *
 * See http://ionicframework.com/docs/components/#navigation for more info
 * on Ionic pages and navigation.
 */

@Component({
  selector: 'page-product-detail',
  templateUrl: 'product-detail.html',
})
export class ProductDetailPage {
  productDetailData: ProductDetailModel = new ProductDetailModel();
  constructor(public navCtrl: NavController, public navParams: NavParams, public app: App, public productDetailServiceProvider: ProductDetailServiceProvider, public loadingProvider: LoadingProvider) {

  }

  ionViewDidLoad() {
    console.log('ionViewDidLoad ProductDetailPage');
    this.getProductDetail();
  }

  getProductDetail() {
    this.loadingProvider.onLoading();

    this.productDetailServiceProvider.getProductDetailData().then((data) => {
      this.productDetailData = data;
      this.loadingProvider.dismiss();
    }, (error) => {
      console.log(error);
      this.loadingProvider.dismiss();
    });
  }

  getCount() {
    return window.localStorage.getItem('e3cartBadge');
  }

  addToCart(item) {
    let className = document.getElementById("badge").className.replace('face', '');
    document.getElementById("badge").className = className;
    setTimeout(() => {
      document.getElementById("badge").className += ' face';
    }, 100);
  }
}
