import { Component, ElementRef } from '@angular/core';
import { App, NavController, NavParams } from 'ionic-angular';

import { AuthenPage } from "../authen/authen";
import { HelpPage } from "../help/help";
import { PolicyPage } from "../policy/policy";
import { AddressPage } from "../address/address";
import { HistoryPage } from "../history/history";
import { NotificationPage } from "../notification/notification";
import { AboutPage } from "../about/about";

import { HeaderContentProvider } from "../../providers/header-content/header-content";


/**
 * Generated class for the SettingPage page.
 *
 * See http://ionicframework.com/docs/components/#navigation for more info
 * on Ionic pages and navigation.
 */

@Component({
  selector: 'page-setting',
  templateUrl: 'setting.html',
})
export class SettingPage {
  ionScroll: any;
  start: number = 0;
  slideHeaderPrevious: number = 0;
  hideheader: boolean;
  constructor(public app: App, public navCtrl: NavController, public navParams: NavParams, public myElement: ElementRef, public headerContentProvider: HeaderContentProvider) {
  }

  ionViewDidLoad() {
    console.log('SettingPage');
  }

  gotoAuthen() {
    this.app.getRootNav().push(AuthenPage);
  }
  gotoHistory() {
    this.app.getRootNav().push(HistoryPage);
  }
  gotoHelp() {
    this.app.getRootNav().push(HelpPage);
  }
  gotoPolicy() {
    this.app.getRootNav().push(PolicyPage);
  }
  gotoAddress() {
    this.app.getRootNav().push(AddressPage);
  }
  gotoNotification() {
    this.app.getRootNav().push(NotificationPage);
  }
  gotoAbout() {
    this.app.getRootNav().push(AboutPage);
  }
}
