import { Injectable } from '@angular/core';
import { Http } from '@angular/http';
import 'rxjs/add/operator/map';
import 'rxjs/add/operator/toPromise';
import { ProductDetailModel } from "../../models/pages/product-detail.model";

/*
  Generated class for the ProductDetailServiceProvider provider.

  See https://angular.io/docs/ts/latest/guide/dependency-injection.html
  for more info on providers and Angular DI.
*/
@Injectable()
export class ProductDetailServiceProvider {

  constructor(public http: Http) {
    console.log('Hello ProductDetailServiceProvider Provider');
  }

  getProductDetailData(): Promise<ProductDetailModel> {
    return this.http.get('./assets/json/product-detail.json')
      .toPromise()
      .then(response => response.json() as ProductDetailModel)
      .catch(this.handleError);
  }

  private handleError(error: any): Promise<any> {
    return Promise.reject(error.message || error);
  }


}
